<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" <?php language_attributes( 'xhtml' ); ?>>
<head profile="http://gmpg.org/xfn/11">
<meta http-equiv="Content-Type" content="<?php bloginfo('html_type'); ?>; charset=<?php bloginfo('charset'); ?>" />
<title><?php tj_custom_titles(); ?></title>
<?php tj_custom_description(); ?>
<?php tj_custom_keywords(); ?>
<?php tj_custom_canonical(); ?>

<link rel="profile" href="http://gmpg.org/xfn/11" />
<link rel="stylesheet" type="text/css" media="all" href="<?php bloginfo( 'stylesheet_url' ); ?>" />
<link rel="alternate" type="application/rss+xml" title="<?php bloginfo('name'); ?> RSS Feed" href="<?php bloginfo('rss2_url'); ?>" />
<link rel="alternate" type="application/atom+xml" title="<?php bloginfo('name'); ?> Atom Feed" href="<?php bloginfo('atom_url'); ?>" />
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
<link rel="stylesheet" type="text/css" href="<?php bloginfo( 'template_url' ); ?>/styles/<?php echo get_option('tpthemes_theme_stylesheet');?>" />	
<link rel="stylesheet" type="text/css" href="<?php bloginfo( 'template_url' ); ?>/custom.css" />
<link rel="stylesheet" type="text/css" href="<?php bloginfo( 'template_url' ); ?>/styles/button_styles.css" />
<link href='http://fonts.googleapis.com/css?family=Open+Sans' rel='stylesheet' type='text/css'>
<link href='http://fonts.googleapis.com/css?family=Questrial' rel='stylesheet' type='text/css'>
<link rel="stylesheet" type="text/css" href="<?php bloginfo( 'template_url' ); ?>/styles/skin.css" />
<link rel="shortcut icon" href="<?php bloginfo( 'template_url' ); ?>/images/favicon.ico" />

<?php wp_head(); ?>

    <script type="text/javascript" src="<?php bloginfo( 'template_url' ); ?>/js/jquery.min.js"></script>
    <script type="text/javascript" src="<?php bloginfo( 'template_url' ); ?>/js/jquery.jcarousel.min.js"></script>
	<script type="text/javascript">    
		jQuery(document).ready(function() {
			jQuery('#mycarousel').jcarousel({
				scroll:1
			});
		});    
    </script>
    
</head>

<body <?php body_class(); ?>>

<?php if (is_home() || is_archive() || is_search() ) add_filter('img_caption_shortcode', create_function('$a, $b, $c','return $c;'), 10, 3); ?>

<div id="wrapper">

	<div id="top">
        	<div class="right-top">
            <ul>
			   <li><?php clpr_register(); ?></li>
               </ul>
           </div>
        	
		<?php if(get_option('tpthemes_headline_news_enable') == 'on') { ?>
		<span><?php _e('Travel News', 'tutspress'); ?>:</span>
        
		<ul id="ticker">
		<?php 
			query_posts( array(
				'tag' => get_option('tpthemes_headline_news_tags'),
				'showposts' => get_option('tpthemes_headline_news_num')
			));
			if( have_posts() ) : while( have_posts() ) : the_post();
		?>
			<li>
				<a href="<?php the_permalink(); ?>" title="<?php printf( esc_attr__( 'Permalink to %s', 'tutspress' ), the_title_attribute( 'echo=0' ) ); ?>" rel="bookmark"><?php the_title(); ?></a> <?php echo human_time_diff(get_the_time('U'), current_time('timestamp')) . ' ago'; ?>
			</li>
		<?php endwhile; endif; wp_reset_query(); ?>
		</ul> <!-- end #ticker -->	
			
		<?php } ?>      
						
	</div> <!-- end #top -->

	<div id="header">
	
		<?php if (get_option('tpthemes_header_style') == 'Header with Quotes') { ?>
	
			<div class="header-quote quote-left">
		    	<span class="img"><img src="<?php echo get_option('tpthemes_header_left_quote_img'); ?>" alt="" /></span> 
		        <span class="quote-text"> 
		            <span class="quote-bold"><?php echo get_option('tpthemes_header_left_quote_bold'); ?></span> 
		            <span class="quote"><?php echo get_option('tpthemes_header_left_quote'); ?></span> 
		        </span> 
		  	</div><!-- end .header-quote .quote-left --> 
	  	
	  	<?php } ?>
	
		<?php if (get_option('tpthemes_header_style') == 'Header with Quotes') { echo('<div id="header-with-quote">'); } else { echo('<div id="header-with-ad">'); } ?>
		
		<?php if (get_option('tpthemes_text_logo_enable') == 'on') { ?>
		
			<div id="text-logo">
				<h1 id="site-title"><a href="<?php bloginfo('url'); ?>"><?php bloginfo('name'); ?></a></h1>
				<p id="site-desc"><?php bloginfo('description'); ?></p>
			</div>
			
		<?php } else { ?>
		
			<a href="<?php bloginfo('url'); ?>"><?php $logo = (get_option('tpthemes_logo') <> '') ? get_option('tpthemes_logo') : get_bloginfo('template_directory').'/images/logo.png'; ?><img src="<?php echo $logo; ?>" alt="<?php bloginfo('name'); ?>" id="logo"/></a>
			
		<?php } ?>
	    
	    </div> <!-- #header-with-quote #header-with-ad -->
	    
		<?php if (get_option('tpthemes_header_style') == 'Header with Quotes') { ?>
	    
		    <div class="header-quote quote-right">
		        <span class="img"><img src="<?php echo get_option('tpthemes_header_right_quote_img'); ?>" alt="" /></span>
		        <span class="quote-text"> 
		            <span class="quote-bold"><?php echo get_option('tpthemes_header_right_quote_bold'); ?></span> 
		            <span class="quote"><?php echo get_option('tpthemes_header_right_quote'); ?></span> 
		        </span>
		    </div> <!--end .header-quote .quote-right--> 
	
	  	<?php } ?>
	  	
		<?php if (get_option('tpthemes_header_style') == 'Header with Advertisement' && get_option('tpthemes_header_ad_enable') == 'on' ) { ?>
			
			<div class="header-ad">
				<?php echo (get_option('tpthemes_header_ad_code')); ?>
			</div>
			
		<?php } ?>
	  	
		<div class="clear"></div>    
			
	</div><!--end #header-->

	<div id="primary-nav">
	
		<div class="nav">
		
			<?php $menuClass = '';
			$menuID = '';
			$primaryNav = '';
			if (function_exists('wp_nav_menu')) {
				$primaryNav = wp_nav_menu( array( 'theme_location' => 'primary-nav', 'container' => '', 'fallback_cb' => '', 'menu_class' => $menuClass, 'menu_id' => $menuID, 'echo' => false ) ); 
			};
			if ($primaryNav == '') { ?>
				<ul id="<?php echo $menuID; ?>" class="<?php echo $menuClass; ?>">
					<?php if (get_option('tpthemes_home_link') == 'on') { ?>
						<li class="home-list"><a href="<?php bloginfo('url'); ?>" class="home <?php if(is_home()) echo('first'); ?>"><?php _e('Home', 'tutspress') ?></a></li>	
					<?php } ?>					
					<?php show_categories_menu($menuClass,false,false); ?>
				</ul>
			<?php }	else echo($primaryNav); ?>
            <div id="search">
			<form method="get" id="searchform" action="<?php bloginfo('url'); ?>">
				<input type="text" class="field" name="s" id="s"  value="<?php _e('Search this site...', 'tutspress') ?>" onfocus="if (this.value == '<?php _e('Search this site...', 'tutspress') ?>') {this.value = '';}" onblur="if (this.value == '') {this.value = '<?php _e('Search this site...', 'tutspress') ?>';}" />
				<input id="searchsubmit" type="image" src="<?php bloginfo('template_directory'); ?>/images/ico-search.gif" value="Go" />
			</form>
		</div><!--end #search -->  
		</div><!--end .nav-->
		
	</div><!--#primary-nav-->
	
	<div id="secondary-nav"> 
		
		<div class="nav">
	
			<?php $menuClass = '';
			$menuID = '';
			$secondaryNav = '';
			if (function_exists('wp_nav_menu')) {
				$secondaryNav = wp_nav_menu( array( 'theme_location' => 'secondary-nav', 'container' => '', 'fallback_cb' => '', 'menu_class' => $menuClass, 'menu_id' => $menuID, 'echo' => false ) ); 
			};
			if ($secondaryNav == '') { ?>
				<ul id="<?php echo $menuID; ?>" class="<?php echo $menuClass; ?>">
					<?php show_page_menu($menuClass,false,false); ?>
				</ul>
			<?php }	else echo($secondaryNav); ?>

		</div><!--end .nav-->
        
	</div> <!--end #secondary-nav-->

	<div id="container">