<?php get_header(); ?>

<div id="content">

	<?php include(TEMPLATEPATH. '/includes/templates/breadcrumbs.php'); ?>

	<?php the_post(); ?>
	
		<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
				
			<h1 class="entry-title"><?php the_title(); ?></h1>
			
			<div class="entry-meta">
				<?php _e('Posted about', 'TravelPress'); ?> <abbr title="<?php the_time('F j, Y'); ?> at <?php the_time('g:i a'); ?>"><?php echo human_time_diff(get_the_time('U'), current_time('timestamp')) . __(' ago', 'TravelPress'); ?></abbr> <span class="entry-sep">|</span> <span class="entry-comment"><?php comments_popup_link( __( '0 comment', 'TravelPress' ), __( '1 comment', 'TravelPress' ), __( '% comments', 'TravelPress' ) ); ?></span></span>
			</div> <!--end .entry-meta-->
    
			<div class="entry entry-content">
			
				<?php if(get_option('tpthemes_integrate_singletop_enable') == 'on') echo (get_option('tpthemes_integration_single_top')); ?>
			
				<?php the_content(); ?>
				<?php wp_link_pages( array( 'before' => '<div class="page-link">' . __( 'Pages:', 'TravelPress' ), 'after' => '</div>' ) ); ?>
			
				<?php if(get_option('tpthemes_integrate_singlebottom_enable') == 'on') echo (get_option('tpthemes_integration_single_bottom')); ?>
			
            
        <div class="postnavi">
	 		<div class="left">
      		<?php previous_post_link('%link', '<p>&laquo; Previous</p>%title', false);  ?>
    		</div>
    		<div class="right">
      			<?php next_post_link('%link', '<p>Next &raquo;</p>%title', false); ?>
    		</div>
    		<div class="clear"></div>
    	</div> <!--end .postnavi-->
        
			</div> <!--end .entry-->

			<?php printf(the_tags(__('<div class="entry-tags"><span>Tags:</span>&nbsp;','TravelPress'),', ','</div>')); ?>
           

			<?php if(get_option('tpthemes_show_author_box') == 'on') { ?> 
			
				<div class="entry-author clear">
					<div class="author-avatar">
					<?php echo get_avatar( get_the_author_meta( 'user_email' ), apply_filters( 'TravelPress_author_bio_avatar_size', 52 ) ); ?>
					</div> <!--end .author-avatar-->
					<div class="author-description">
						<h3><?php the_author(); ?></h3>
						<?php the_author_meta( 'description' ); ?>
						<div id="author-link">
							<a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>" title="<?php printf( esc_attr__( 'View all posts by %s', 'TravelPress' ), get_the_author() ); ?>"><?php _e( 'View all posts by ', 'TravelPress' ); ?><?php the_author(); ?> &rarr;</a>
						</div> <!--end .author-link-->
					</div> <!--end .author-description-->
				</div> <!--end .entry-author-->

			<?php } ?>	

			<?php if(get_option('tpthemes_show_entry_bottom') == 'on') { ?>
			
				<div class="entry-bottom">
				
					<div class="entry-social">
						<h3 class="section-title"><?php _e('What Next?', 'TravelPress'); ?></h3>
						<?php echo tj_social_bookmarks(); ?>	
					</div> <!--end .entry-social-->	
					
					<div class="entry-related-posts">
						<?php echo tj_related_posts(); ?>
					</div> <!-- end .entry-related-posts -->
			
					<div class="clear"></div>
			
				</div> <!-- end .entry-bottom -->			
			
			<?php } ?>
				
		</div> <!--end #post-->

<?php if(get_option('tpthemes_show_post_comments') == 'on') comments_template( '', true ); ?>

</div><!--end #content-->

    <ul id="column3-single">
     <?php include_once('home-sidebar-left.php'); ?>
    </ul><!--end column2-->

<?php get_sidebar(); ?>

<?php get_footer(); ?>
