<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
	xmlns:sm="http://www.sitemaps.org/schemas/sitemap/0.9" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:video="http://www.google.com/schemas/sitemap-video/1.1" xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:xhtml="http://www.w3.org/1999/xhtml" xmlns="http://www.w3.org/1999/xhtml">
	<xsl:template match="/">
		<html>
			<head>
				<title>Cool Video Gallery - Video XML Sitemap</title>
				<style type="text/css">
					body {
					background-color: #FFF;
					margin:0;
					text-align:center;
					}
					a:link {
					color: #2583AD;
					text-decoration: none;
					}
					a:hover {
					color: #2583AD;
					}
					a:visited {
					color: #2583AD;
					}
					h2 {
					background-color:#fff;
					padding:20px;
					color:#2583AD;
					text-align:left;
					font-size:32px;
					margin:0px;
					}
					th {
					background-color:#2583AD;
					color:#fff;
					padding:4px;
					text-align:left;
					}
					td{
					font-size:12px;
					padding:2px;
					text-align:left;
					}
					tr {background: #fff}
					tr:nth-child(odd) {background: #f9f9f9}
					#footer {
					background-color:#2583AD;
					padding:10px;
					text-align:right;
					font-size:10px;
					color:#fff;
					}
				</style>
			</head>
			<body>
				<div id="cont">
					<h2>
						Google Video XML Sitemap
						<span style="font-weight:lighter;font-size:12px;">- generated by Cool Video Gallery</span>
					</h2>

					<xsl:apply-templates />

					<div id="footer">
						Created with Cool Video Gallery WordPress Plugin, Copyright (c)
						2016
						<a href="https://wordpress.org/plugins/cool-video-gallery/">Cool Video Gallery</a>
					</div>
				</div>
			</body>
		</html>
	</xsl:template>

	<xsl:template match="sm:urlset">
		<table cellpadding="0" cellspacing="0" width="100%">
			<tr style="height:50px;">
				<th></th>
				<th>URL</th>
				<th>VIDEO PREVIEW</th>
				<th>VIDEO TITLE / DESCRIPTION</th>
			</tr>
			<xsl:for-each select="sm:url">
				<tr style="height:50px;">
					<xsl:variable name="loc">
						<xsl:value-of select="sm:loc" />
					</xsl:variable>
					<xsl:variable name="pno">
						<xsl:value-of select="position()" />
					</xsl:variable>
					<td style="text-align:center;font-size:14px;font-weight:bold;">
						<xsl:value-of select="$pno" />
					</td>
					<td colspan="3">
						<a href="{$loc}" style="font-size:14px;font-weight:bold;">
							<xsl:value-of select="sm:loc" />
						</a>
					</td>
				</tr>
				<xsl:apply-templates select="video:*" />
			</xsl:for-each>
		</table>
	</xsl:template>

	<xsl:template match="video:*">
	</xsl:template>

	<xsl:template match="video:video">
		<tr>
			<xsl:variable name="loc">
				<xsl:choose>
					<xsl:when test="video:player_loc != ''">
						<xsl:value-of select="video:player_loc" />
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="video:content_loc" />
					</xsl:otherwise>
				</xsl:choose>
			</xsl:variable>
			<xsl:variable name="thumb">
				<xsl:value-of select="video:thumbnail_loc" />
			</xsl:variable>
			<xsl:variable name="pno">
				<xsl:value-of select="position()" />
			</xsl:variable>
			<td style="width:5%;text-align:right;">
				(<xsl:value-of select="$pno" />)
			</td>
			<td style="width:35%">
				<a href="{$loc}">
					<xsl:choose>
						<xsl:when test="video:player_loc != ''">
							<xsl:value-of select="video:player_loc" />
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="video:content_loc" />
						</xsl:otherwise>
					</xsl:choose>
				</a>
			</td>
			<td style="width:20%">

				<xsl:if test="video:thumbnail_loc != ''">
					<br />
					<img src="{$thumb}" alt="" width="100" height="100" />
					<br />
					<br />
				</xsl:if>
			</td>
			<td style="width:40%">
				<div>
					<span style="font-weight:bold;">Title: </span>
					<xsl:value-of select="video:title" />
					<br />
					<br />
				</div>
				<span style="font-weight:bold;">Description: </span>
				<xsl:value-of select="video:description" />
			</td>
			<xsl:apply-templates />
		</tr>
	</xsl:template>
</xsl:stylesheet>